/*
 * Creted by Simao Pinto Correia.
 * created in portugal , on Wednesday ,26th ,Jun,2019
 * All rights reserved.
 */
/+++++++++++++++++++++++++++++++++++++++++++++++++++++++++WIRING SEQUENCE+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
/*
 * LCD:
 * vss,GND
 * vdd,+5V
 * vo ,GND
 * rs,2
 * rw,GND
 * e,3
 * d4,4
 * d5,5
 * d6,6
 * d7,7
 * A,+5V
 * K,GND
 * ultra -sonic(HC-SR05):
 * vcc.+5V
 * echo,12
 * trig,13
 * output ,____
 * GND,GND
 * BUZZER:
 * pin1,GND
 * pin2,9(PWM~)
 * potenciometer:
 * pin1,GND
 * Cursor,A4
 * pin2,+5V
 * flame sensor 
 * GND,GND
 * VCC,A3
 * tilt swtch:
 * pin1,GND
 * pin2,A2
 * LDR:
 * pin1,GND
 * pin2,A1
 * LM35:
 * vcc,+5v
 * vood,A0
 * GND,GND
 */
#include <LiquidCrystal.h>
LiquidCrystal lcd(2,3,4,5,6,7);
#define ECHO_PIN 12
#define TRIG_PIN 13
#define MELODY_PIN 9
#define FLAME_PIN A3
#define TILT_PIN A2
#define LDR_PIN A1
#define TEMP_PIN A0
//setup mode button:
#define MODE_PIN A4
int faseButtom;
void setup() {
  // put your setup code here, to run once:
pinMode(MELODY_PIN,OUTPUT);
pinMode(ECHO_PIN,INPUT);
pinMode(TRIG_PIN,OUTPUT);
pinMode(FLAME_PIN,INPUT);
pinMode(TILT_PIN,INPUT);
pinMode(LDR_PIN,INPUT);
pinMode(TEMP_PIN,INPUT);
pinMode(MODE_PIN,INPUT);
lcd.begin(16,2);
}

void loop() {
  // put your main code here, to run repeatedly:
if ((analogRead (MODE_PIN)<200)&&(analogRead(MODE_PIN)>0)){
  faseButtom=1;
}
if ((analogRead (MODE_PIN)<400)&&(analogRead(MODE_PIN)>200)){
  faseButtom=2;
}
if ((analogRead (MODE_PIN)<600)&&(analogRead(MODE_PIN)>400)){
  faseButtom=3;
}
if ((analogRead (MODE_PIN)<800)&&(analogRead(MODE_PIN)>600)){
  faseButtom=4;
}
if ((analogRead (MODE_PIN)<1023)&&(analogRead(MODE_PIN)>800)){
  faseButtom=5;
}
if (faseButtom==1){
 noTone(MELODY_PIN);
 long duration,distance;
  digitalWrite(TRIG_PIN,LOW);
  delayMicroseconds(2);
  digitalWrite(TRIG_PIN,HIGH);
  delayMicroseconds(10);
  digitalWrite(TRIG_PIN,LOW);
  duration = pulseIn(ECHO_PIN,HIGH);
  distance = (duration/2) / 29.1;
  //lcd print the results.
  lcd.clear();
  lcd.setCursor(1,0);
  lcd.print("distance:");
  lcd.setCursor(1,1);
  lcd.print(distance);
  lcd.write(' ');
  lcd.print("cm");
}
if (faseButtom==2){
  noTone(MELODY_PIN);
  if (analogRead(FLAME_PIN)<200){
    
  
  lcd.clear();
  lcd.print("fire?");
  }
  else{
    lcd.clear();
    lcd.print("FIRE!");
    tone(MELODY_PIN,200);
    lcd.display();
    delay(500);
    tone(MELODY_PIN,400);
    lcd.noDisplay();
    
    delay(500);
  }
  
}
if(faseButtom==3){
  noTone(MELODY_PIN);
  lcd.clear();
  lcd.print("Tylt Mode");
  if(digitalRead(TILT_PIN)==HIGH){
   noTone(MELODY_PIN);
    lcd.clear();
    lcd.setCursor(1,1);
    lcd.print("no Tylt");
    
  }
  else{
    lcd.clear();
    lcd.setCursor(1,1);
    lcd.print("Tylting...");
    tone(MELODY_PIN,200);
    delay(500);
    tone(MELODY_PIN,400);
    delay(400);
    tone(MELODY_PIN,600);
    delay(500);
}
}
if(faseButtom==4){
  noTone(MELODY_PIN);
  long READ;
  READ=analogRead(LDR_PIN)*100/1023;
  lcd.clear();
  lcd.print("light");
  lcd.setCursor(1,1);
  lcd.print(READ);
  lcd.write(' ');
  lcd.write('%');
}
if (faseButtom==5){
 noTone(MELODY_PIN);
 long temperature;
 temperature = analogRead(TEMP_PIN)*500/1023;
  lcd.clear();
  lcd.print("Temp:");
  lcd.setCursor(1,1);
  lcd.print(temperature);
  lcd.print(" degrees C");
  delay(1000);
}
delay(200);

}
